/*
 * KHeiseReg
 *
 * A utility to search for articles within the Heise register.
 *
 * Copyright (C) 2002 Oliver Gantz <Oliver.Gantz@epost.de>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#include <qlayout.h>
#include <qgroupbox.h>
#include <qprogressdialog.h>

#include <klocale.h>
#include <kglobal.h>
#include <kapp.h>

#include "global.h"
#include "regfile.h"
#include "kheiseview.h"


KHeiseView::KHeiseView(QWidget *parent, const char *name): QWidget(parent, name)
{
	QBoxLayout *vbox;
	QGridLayout *grid;
	QGroupBox *gbox;
	QLabel *label;

	vbox = new QVBoxLayout(this, 8);

	articleview = new ArticleView(this, "articleview");
	CHECK_PTR(articleview);

	vbox->addWidget(articleview);
	
	gbox = new QGroupBox(this);
	
	grid = new QGridLayout(gbox, 5, 6, 8);

	label = new QLabel(i18n("Title:"), gbox);
	label->setFixedSize(label->sizeHint());
	grid->addWidget(label, 0, 0, AlignVCenter | AlignRight);
	
	title = new QLabel(gbox);
	title->setFrameStyle(QFrame::Panel | QFrame::Sunken);
	title->setMinimumSize(title->sizeHint());
	grid->addMultiCellWidget(title, 0, 0, 1, 5);
	
	label = new QLabel(i18n("Subtitle:"), gbox);
	label->setFixedSize(label->sizeHint());
	grid->addWidget(label, 1, 0, AlignVCenter | AlignRight);
	
	subtitle = new QLabel(gbox);
	subtitle->setFrameStyle(QFrame::Panel | QFrame::Sunken);
	subtitle->setMinimumSize(subtitle->sizeHint());
	grid->addMultiCellWidget(subtitle, 1, 1, 1, 5);
	
	label = new QLabel(i18n("Author(s):"), gbox);
	label->setFixedSize(label->sizeHint());
	grid->addWidget(label, 2, 0, AlignVCenter | AlignRight);
	
	author = new QLabel(gbox);
	author->setFrameStyle(QFrame::Panel | QFrame::Sunken);
	author->setMinimumSize(author->sizeHint());
	grid->addMultiCellWidget(author, 2, 2, 1, 3);
	
	label = new QLabel(i18n("Editor:"), gbox);
	label->setFixedSize(label->sizeHint());
	grid->addWidget(label, 2, 4, AlignVCenter | AlignRight);
	
	editor = new QLabel(gbox);
	editor->setFrameStyle(QFrame::Panel | QFrame::Sunken);
	editor->setMinimumSize(editor->sizeHint());
	grid->addWidget(editor, 2, 5);
	
	label = new QLabel(i18n("Magazine:"), gbox);
	label->setFixedSize(label->sizeHint());
	grid->addWidget(label, 3, 0, AlignVCenter | AlignRight);
	
	magazine = new QLabel(gbox);
	magazine->setFrameStyle(QFrame::Panel | QFrame::Sunken);
	magazine->setMinimumSize(magazine->sizeHint());
	grid->addWidget(magazine, 3, 1);
	
	label = new QLabel(i18n("Edition:"), gbox);
	label->setFixedSize(label->sizeHint());
	grid->addWidget(label, 3, 2, AlignVCenter | AlignRight);
	
	edition = new QLabel(gbox);
	edition->setFrameStyle(QFrame::Panel | QFrame::Sunken);
	edition->setMinimumSize(edition->sizeHint());
	grid->addWidget(edition, 3, 3);
	
	label = new QLabel(i18n("Page:"), gbox);
	label->setFixedSize(label->sizeHint());
	grid->addWidget(label, 3, 4, AlignVCenter | AlignRight);
	
	page = new QLabel(gbox);
	page->setFrameStyle(QFrame::Panel | QFrame::Sunken);
	page->setMinimumSize(page->sizeHint());
	grid->addWidget(page, 3, 5);
	
	label = new QLabel(i18n("Links:"), gbox);
	label->setFixedSize(label->sizeHint());
	grid->addWidget(label, 4, 0, AlignVCenter | AlignRight);
	
	links = new QLabel(gbox);
	links->setFrameStyle(QFrame::Panel | QFrame::Sunken);
	links->setMinimumSize(links->sizeHint());
	grid->addMultiCellWidget(links, 4, 4, 1, 5);
	
	grid->setColStretch(0, 0);
	grid->setColStretch(1, 1);
	grid->setColStretch(2, 0);
	grid->setColStretch(3, 1);
	grid->setColStretch(4, 0);
	grid->setColStretch(5, 1);

	grid->activate();

	vbox->addWidget(gbox);

	vbox->activate();

	connect(articleview, SIGNAL(currentChanged(QListViewItem *)), this, SLOT(currentChangedSlot(QListViewItem *)));
}


KHeiseView::~KHeiseView()
{
}


void KHeiseView::readOptions()
{
	articleview->readOptions();
}


void KHeiseView::saveOptions()
{
	articleview->saveOptions();
}


void KHeiseView::search(const RegMask &mask)
{
	RegFile file(expandPath(REGISTER_FILE));
	RegEntry entry;
	int i = 0, count = 0;
	QProgressDialog progress(0, "progressdlg", true);
	
	articleview->clear();

	file.open(IO_ReadOnly);

	progress.setCaption(i18n("KHeiseReg Search"));
	progress.setLabelText(i18n("Searching..."));
	progress.setTotalSteps(file.size());

//	articleview->setUpdatesEnabled(false);
	while (file.readEntry(&entry)) {
		if (mask.matches(entry)) {
			articleview->addEntry(entry);
			count++;
		}
		if (++i == 200) {
			progress.setProgress(file.at());
			kapp->processEvents();
			if (progress.wasCancelled())
				break;
			i = 0;
		}
	}
	kapp->processEvents();
//	articleview->setUpdatesEnabled(true);
//	articleview->repaint();
	file.close();

	emit items(count);
}


void KHeiseView::currentChangedSlot(QListViewItem *item)
{
	if (item) {
		title->setText(((ArticleViewItem *)item)->title());
		subtitle->setText(((ArticleViewItem *)item)->subTitle());
		author->setText(((ArticleViewItem *)item)->authors());
		editor->setText(((ArticleViewItem *)item)->editor());
		magazine->setText(((ArticleViewItem *)item)->magazine());
		edition->setText(((ArticleViewItem *)item)->edition());
		page->setText(((ArticleViewItem *)item)->page());
		links->setText(((ArticleViewItem *)item)->links());
	}
}
